-- Now we need to update all store procedure that use this one
--  1. [sp_ImportRespondent]
/****** Object:  StoredProcedure [dbo].[sp_ImportRespondent]    Script Date: 11/09/2011 10:13:23 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_ImportRespondent]') AND type in (N'P', N'PC'))
  DROP PROCEDURE [dbo].[sp_ImportRespondent]
GO
/****** Object:  StoredProcedure [dbo].[sp_ImportRespondent]    Script Date: 11/09/2011 10:13:23 ******/
  -- Changed way to extract code for the time zone (bug #11450)
  CREATE PROCEDURE [dbo].[sp_ImportRespondent]
  (
    @projectId int,
    @userId int,
    @resRespondent varchar(10),
    @resLanguage int,
    @resTimeZone int,
    @resIntervCall varchar(10),
    @resConfidPhone bit,
    @resPhone varchar(20),
    @resPriority int,
    @resWaveImportNo int,
    @resActive int,
    @ExtractTimeZoneFromAreaCode bit,
    @CheckPhoneForDuplicate bit,
    @resSeed         int,
    @DialingMode int = 0,
    @IntLevel int = 0,
	@ResCodeResult varchar(2) = null
	
  )
  AS

    if @CheckPhoneForDuplicate =1  and @resphone <> '' and @resphone is not null
    begin
      declare @key varchar(10)
      select @key = resRespondent from dbo.respondent where resphone=@resphone

      if @key is not null
      begin
        RAISERROR ('VOXCOERROR_1000 Duplicate phone numbers are not allowed.', 16, 1)
        return
      end
    end

     if @ExtractTimeZoneFromAreaCode =1
    begin
      declare @parTimeZone int,
	          @resPhoneSearch varchar(20)
	  set @resPhoneSearch=replace(@resphone,'-','')
      select @parTimeZone = coalesce(timezone,0) 
      from   areacodetz
	  where areacodetz.code = Substring(@resPhoneSearch,Patindex('%[0-9]%',@resPhoneSearch),3)
			and areacodetz.exchange = Substring(@resPhoneSearch,(Patindex('%[0-9]%',@resPhoneSearch) + 3),3)
	  
	   if @parTimeZone is null
	   begin
		   select @resTimeZone = coalesce(timezone,0) 
		   from   areacodetz
		   where  areacodetz.code = Substring(@resPhoneSearch,Patindex('%[0-9]%',@resPhoneSearch),3)
		   and areacodetz.exchange = '***'
	   end 
	   set @resTimeZone=isnull(@parTimeZone,@resTimeZone)
    end

    insert into dbo.respondent (ResRespondent,ResLanguage,ResTimeZone,ResCallbackDate,ResIntervCall,ResTimeSlot,ResCallCount,ResLastCallDate,ResVersion,ResPriority,ResCompleted,ResConfidPhone,ResSeed,Resphone,ResCodeResult,ResWaveNo,ResBlocked,ResCompPredictive,ResCall,ResMonitored,ResLastCompQuest,ResPreviousCallDate,ResWaveImportNo, ResActive, projectid,modifiedby,modified,collectmode,DialingMode,IntLevel)
    values(
      @resRespondent,
      @resLanguage,
      @resTimeZone,
      0,
      @resIntervCall,
      0,
      0,
      null,
      null,
      @resPriority,
      0,
      @resConfidPhone,
      @resSeed,
      @resPhone,
      @resCodeResult,
      0,
      0,
      0,
      0,
      0,
      0,
      null,
      @resWaveImportNo,
      @resActive,
      @projectId,
      @userId,
      GETUTCDATE(),
      0,
      @DialingMode,
      @IntLevel
    )

    if @ExtractTimeZoneFromAreaCode =1
    begin
      declare @tzone varchar(2)
      if @resTimeZone <10  
        set @tzone = '0' + cast(@restimezone as varchar)
      else 
        set @tzone= cast(@restimezone as varchar)
        
      exec Sp_updaterespondentresponse @projectId,@userId,0,@resRespondent,'TZONE',1,1,@tzone,'',0,0,'Importation'
    end

GO

/****** Object:  StoredProcedure [dbo].[sp_RecomputeTimeZones]    Script Date: 11/22/2009 14:00:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_recomputetimezones]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_recomputetimezones]
GO
CREATE PROCEDURE [dbo].[Sp_recomputetimezones]
                @projectId INT,
                @userId    INT
AS
  --FIRST SET EVERY RESPONDENT TO TZONE 0
  UPDATE respondent
  SET    restimezone = 0,
         projectid = @projectId,
         modifiedby = @userId,
         modified = Getutcdate()
  
  --SECOND STEP INSERT INTO RESPONSE TZONE FIELD FOR THOSE RESPONDENT WHO DID NOT HAVE IT YET
  INSERT INTO response
  SELECT DISTINCT resrespondent AS rpsrespondent,
                  'TZONE'       AS rpsquestion,
                  1             AS rpsmatrix,
                  1             AS rpsmention,
                  '00'          AS rpscontent,
                  ''            AS rpsopened,
                  0             AS rpstype,
                  @projectId    AS projectid,
                  0             AS collectmode,
                  @userId       AS modifiedby,
                  modified = Getutcdate(),
                  ''            AS [Source],
                  0             AS CallId
  FROM   respondent subselect
  WHERE  resrespondent NOT IN (SELECT rpsrespondent
                               FROM   response
                               WHERE  rpsquestion = 'TZONE')
  
  -- THIRD STEP UPDATE RESPONDENT WITH A *** EXCHANGE ZONE
  UPDATE respondent
  SET    restimezone = timezone,
         projectid = @projectId,
         modifiedby = @userId,
         modified = Getutcdate()
  FROM   areacodetz
  WHERE  areacodetz.code = Substring(replace(resphone,'-',''),Patindex('%[0-9]%',replace(resphone,'-','')),3)
         AND areacodetz.exchange = '***'
  
  --FOURTH STEP UPDATE RESPONDENT WITH AN DEFINED EXCHANGE ZONE
  UPDATE respondent
  SET    restimezone = timezone,
         projectid = @projectId,
         modifiedby = @userId,
         modified = Getutcdate()
  FROM   areacodetz
  WHERE  areacodetz.code = Substring(replace(resphone,'-',''),Patindex('%[0-9]%',replace(resphone,'-','')),3)
         AND areacodetz.exchange = Substring(replace(resphone,'-',''),(Patindex('%[0-9]%',replace(resphone,'-','')) + 3),
                                             3)
  
  -- LAST STEP  UPDATE TZONE QUESTION
  UPDATE response
  SET    rpscontent = Right(Replicate('0',2) + Convert(VARCHAR(2),restimezone),
                            2),
         projectid = @projectId,
         modifiedby = @userId,
         modified = Getutcdate()
  FROM   respondent
  WHERE  resrespondent = rpsrespondent
         AND rpsquestion = 'TZONE'
         AND rpsmatrix = 1
         AND rpsmention = 1
         AND rpstype = 0

GO

